#ifndef USBPKTDEFS_H
#define USBPKTDEFS_H

#include "carscroll.h"

typedef union _BOOT_DATA_PACKET
{
    byte _byte[BOOT_EP_SIZE];  //For Byte Access
    struct
    {
		union
		{
			ram far byte *pAdrRam;
			struct
			{
				byte low;
				byte high;
				byte upper;
			};
		} ADRA;
		byte dummy;
		MEM_PTR	pAdr;
        byte dummy2;
        enum
        {
			CAR_DISPLAY_RW_RAM						=0xA0,
			CAR_DISPLAY_RW_ROM						=0xA1,
			CAR_DISPLAY_RW_EE						=0xA2,
			CAR_DISPLAY_SET_IMODE					=0xA3,
			CAR_DISPLAY_RESET						=0xA4,
			RESET                   	 			=0xFF
        } CMD;
		byte 	dir;
		byte	varn;
		byte 	index;
	    int 	len;					// number of bytes
		int		iarg;					// integer argument
        byte data[DATA_SIZE];			// the rest of the frame.
    };

} BOOT_DATA_PACKET;

#endif
